/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.compat.jei.device;

import cofh.core.util.helpers.RenderHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermal.core.client.gui.device.DeviceRockGenScreen;
import cofh.thermal.core.init.TCoreReferences;
import cofh.thermal.core.util.recipes.device.RockGenMapping;
import cofh.thermal.lib.compat.jei.Drawables;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;

public class RockGenCategory
implements IRecipeCategory<RockGenMapping> {
    protected static final FluidStack LAVA_FLUID = new FluidStack((Fluid)Fluids.f_76195_, 1000);
    protected final ResourceLocation uid;
    protected IDrawable background;
    protected IDrawable icon;
    protected Component name;
    protected IDrawableStatic slot;
    protected IDrawableStatic progressFluidBackground;
    protected IDrawableAnimated progressFluid;

    public RockGenCategory(IGuiHelper guiHelper, ItemStack icon, ResourceLocation uid) {
        this.uid = uid;
        this.icon = guiHelper.createDrawableIngredient(VanillaTypes.ITEM, (Object)icon);
        this.background = guiHelper.drawableBuilder(DeviceRockGenScreen.TEXTURE, 26, 11, 140, 62).addPadding(0, 0, 16, 8).build();
        this.name = StringHelper.getTextComponent((String)TCoreReferences.DEVICE_ROCK_GEN_BLOCK.m_7705_());
        this.slot = Drawables.getDrawables(guiHelper).getSlot(0);
        this.progressFluidBackground = Drawables.getDrawables(guiHelper).getProgressFill(1);
        this.progressFluid = guiHelper.createAnimatedDrawable(Drawables.getDrawables(guiHelper).getProgress(1), 40, IDrawableAnimated.StartDirection.LEFT, true);
    }

    public ResourceLocation getUid() {
        return this.uid;
    }

    public Class<? extends RockGenMapping> getRecipeClass() {
        return RockGenMapping.class;
    }

    public Component getTitle() {
        return this.name;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RockGenMapping recipe, IFocusGroup focuses) {
        LiquidBlock liquidBlock;
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 23, 13).addIngredients(VanillaTypes.FLUID, List.of(LAVA_FLUID))).setFluidRenderer(1000, false, 16, 16);
        Block adjacent = recipe.getAdjacent();
        Block below = recipe.getBelow();
        builder.addSlot(RecipeIngredientRole.OUTPUT, 115, 24).addItemStack(recipe.getResult());
        if (adjacent instanceof LiquidBlock) {
            liquidBlock = (LiquidBlock)adjacent;
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 45, 13).addIngredients(VanillaTypes.FLUID, List.of(new FluidStack((Fluid)liquidBlock.getFluid(), 1000)))).setFluidRenderer(1000, false, 16, 16);
        } else if (adjacent != Blocks.f_50016_) {
            builder.addSlot(RecipeIngredientRole.INPUT, 45, 13).addItemStack(new ItemStack((ItemLike)adjacent));
        }
        if (below instanceof LiquidBlock) {
            liquidBlock = (LiquidBlock)below;
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 34, 34).addIngredients(VanillaTypes.FLUID, List.of(new FluidStack((Fluid)liquidBlock.getFluid(), 1000)))).setFluidRenderer(1000, false, 16, 16);
        } else if (below != Blocks.f_50016_) {
            builder.addSlot(RecipeIngredientRole.INPUT, 34, 34).addItemStack(new ItemStack((ItemLike)below));
        }
    }

    public void draw(RockGenMapping recipe, IRecipeSlotsView recipeSlotsView, PoseStack matrixStack, double mouseX, double mouseY) {
        if (recipe.getBelow() != Blocks.f_50016_) {
            this.slot.draw(matrixStack, 33, 33);
        }
        RenderHelper.drawFluid((PoseStack)matrixStack, (int)74, (int)23, (FluidStack)LAVA_FLUID, (int)24, (int)16);
        this.progressFluidBackground.draw(matrixStack, 74, 23);
        this.progressFluid.draw(matrixStack, 74, 23);
    }
}

